(function($) {
'use strict';

// Define jRespond Media queries.
var jRes = jRespond([
  {
    label: 'mobile',
    enter: 0,
    exit: 480
  },{
    label: 'tablet',
    enter: 481,
    exit: 979
  },{
    label: 'desktop',
    enter: 980,
    exit: 9999
  }
]);

// Detect Operating system and add class to the body.
Drupal.behaviors.adminimal_os_class = {
  attach: function (context, settings) {
    // Detect if OS is mac based.
    if (navigator.userAgent.indexOf('Mac OS X') != -1) {
      $("body").addClass("mac");
    }
  }
};

// Modify the Search field for module filter.
Drupal.behaviors.adminimal_module_filter_box = {
  attach: function (context, settings) {
    //Add default hint value using the HTML5 placeholder attribute.
    $('input#edit-module-filter-name').attr( "placeholder", Drupal.t('Search') );
  }
};

// Fix some krumo styling.
Drupal.behaviors.krumo_remove_class = {
  attach: function (context, settings) {
    // Find status messages that has krumo div inside them, and change the classes.
    $('#console .messages.status').has("div.krumo-root").removeClass().addClass( "krumo-wrapper" );
  }
};

// Add media query classes to the body tag.
Drupal.behaviors.adminimal_media_queries = {
  attach: function (context, settings) {
    jRes.addFunc([
      {
        breakpoint: 'mobile',
          enter: function() {
            $( "body" ).addClass( "mq-mobile" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-mobile" );
          }
      },{
        breakpoint: 'tablet',
          enter: function() {
            $( "body" ).addClass( "mq-tablet" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-tablet" );
          }
      },{
        breakpoint: 'desktop',
          enter: function() {
            $( "body" ).addClass( "mq-desktop" );
          },
          exit: function() {
            $( "body" ).removeClass( "mq-desktop" );
          }
      }
    ]);
  }
};

// Move the active primary tab on mobile to be displayed last.
Drupal.behaviors.adminimal_move_active_primary_tab = {
  attach: function (context, settings) {
    // Add primary tabs class to the branding div for the bottom border.
    $('#branding').has("ul.tabs.primary").addClass( "has-primary-tabs" );

    // register enter and exit functions for a single breakpoint
    jRes.addFunc({
      breakpoint: 'mobile',
        enter: function() {
          $( "ul.tabs.primary li.active" ).clone().appendTo( "ul.tabs.primary" ).removeClass( "active" ).addClass( "current" );
          $( "ul.tabs.primary li.active" ).css("display", "none");
        },
        exit: function() {
          $( "ul.tabs.primary li.active" ).css("display", "table");
          $( "ul.tabs.primary li.current" ).css("display", "none");
        }
    });
  }
};

})(jQuery);
